/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class FileLock
extends MIDlet
implements CommandListener {
    private String currDirName;
    private Command view = new Command("View", 8, 1);
    private Command hide = new Command("Lock", 8, 2);
    private Command unhide = new Command("UnLock", 8, 3);
    private Command ch_pass = new Command("Change Password", 8, 4);
    private Command ch_passok = new Command("OK", 4, 1);
    private Command ch_passca = new Command("Cancel", 3, 2);
    private Command about = new Command("About", 8, 5);
    private Command exit = new Command("Exit", 7, 3);
    private TextField t_pass;
    private TextField t_npass;
    private TextField t_cpass;
    private Image dirIcon;
    private Image fileIcon;
    private Image[] iconList;
    private static final String UP_DIRECTORY = "..";
    private static final String MEGA_ROOT = "/";
    private static final String SEP_STR = "/";
    private static final char SEP = '/';
    private static String copyright = "By Sina Parastegari\nsina_parastgary@\nyahoo.com\nSummer 1385";
    private boolean p_sorg;

    public FileLock() {
        this.currDirName = Mem.getLastURL();
        try {
            this.dirIcon = Image.createImage((String)"/icons/dir.png");
        }
        catch (IOException iOException) {
            this.dirIcon = null;
        }
        try {
            this.fileIcon = Image.createImage((String)"/icons/file.png");
        }
        catch (IOException iOException) {
            this.fileIcon = null;
        }
        this.iconList = new Image[]{this.fileIcon, this.dirIcon};
    }

    public void startApp() {
        Form form = new Form("File Lock");
        try {
            form.append("Please Wait...");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
            if (Mem.getPassword().equals("")) {
                this.setPass();
            } else {
                this.getPass();
            }
        }
        catch (SecurityException securityException) {
            Alert alert = new Alert("Error", "You are not authorized to access the restricted API", null, AlertType.ERROR);
            alert.setTimeout(-2);
            Form form2 = new Form("Cannot access FileConnection");
            form2.append((Item)new StringItem(null, "You cannot run this MIDlet with the current permissions. Sign the MIDlet suite, or run it in a different security domain"));
            form2.addCommand(this.exit);
            form2.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent(alert, (Displayable)form2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.notifyDestroyed();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.view) {
            List list = (List)displayable;
            final String string = list.getString(list.getSelectedIndex());
            new Thread(new Runnable(){

                public void run() {
                    if (string.endsWith("/") || string.equals(FileLock.UP_DIRECTORY)) {
                        FileLock.this.traverseDirectory(string);
                    } else {
                        FileLock.this.f_hide(string, 3);
                    }
                }
            }).start();
        } else if (command == this.hide) {
            List list = (List)displayable;
            final String string = list.getString(list.getSelectedIndex());
            new Thread(new Runnable(){

                public void run() {
                    FileLock.this.f_hide(string, 1);
                }
            }).start();
        } else if (command == this.unhide) {
            List list = (List)displayable;
            final String string = list.getString(list.getSelectedIndex());
            new Thread(new Runnable(){

                public void run() {
                    FileLock.this.f_hide(string, 2);
                }
            }).start();
        } else if (command == this.exit) {
            Mem.setLastURL(this.currDirName);
            this.destroyApp(false);
        } else if (command == this.ch_pass) {
            this.setPass();
        } else if (command == this.ch_passok) {
            if (this.p_sorg) {
                if (this.t_pass.getString().equals(Mem.getPassword())) {
                    new Thread(new Runnable(){

                        public void run() {
                            FileLock.this.showCurrDir();
                        }
                    }).start();
                } else {
                    Alert alert = new Alert("Error", "Password is wrong!", null, AlertType.ERROR);
                    alert.setTimeout(-2);
                    Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
                }
            } else if (this.t_npass.getString().equals(this.t_cpass.getString())) {
                new Thread(new Runnable(){

                    public void run() {
                        Mem.setPassword(FileLock.this.t_npass.getString());
                        FileLock.this.showCurrDir();
                    }
                }).start();
            } else {
                Alert alert = new Alert("Error", "Password confirmation isn't same as entered password.", null, AlertType.ERROR);
                alert.setTimeout(-2);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
            }
        } else if (command == this.ch_passca) {
            if (this.p_sorg) {
                this.destroyApp(false);
            } else {
                new Thread(new Runnable(){

                    public void run() {
                        FileLock.this.showCurrDir();
                    }
                }).start();
            }
        } else if (command == this.about) {
            Alert alert = new Alert("About FileLock:");
            alert.setString(copyright);
            alert.setTimeout(-2);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
        }
    }

    void showCurrDir() {
        FileConnection fileConnection = null;
        try {
            List list;
            Enumeration enumeration;
            if ("/".equals(this.currDirName)) {
                enumeration = FileSystemRegistry.listRoots();
                list = new List(this.currDirName, 3);
            } else {
                fileConnection = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName));
                enumeration = fileConnection.list();
                list = new List(this.currDirName, 3);
                list.append(UP_DIRECTORY, this.dirIcon);
            }
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.charAt(string.length() - 1) == '/') {
                    list.append(string, this.dirIcon);
                    continue;
                }
                list.append(string, this.fileIcon);
            }
            list.setSelectCommand(this.view);
            list.addCommand(this.hide);
            list.addCommand(this.unhide);
            list.addCommand(this.ch_pass);
            list.addCommand(this.about);
            list.addCommand(this.exit);
            list.setCommandListener((CommandListener)this);
            if (fileConnection != null) {
                fileConnection.close();
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)list);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void traverseDirectory(String string) {
        if (this.currDirName.equals("/")) {
            if (string.equals(UP_DIRECTORY)) {
                return;
            }
            this.currDirName = string;
        } else {
            int n;
            this.currDirName = string.equals(UP_DIRECTORY) ? ((n = this.currDirName.lastIndexOf(47, this.currDirName.length() - 2)) != -1 ? this.currDirName.substring(0, n + 1) : "/") : this.currDirName + string;
        }
        this.showCurrDir();
    }

    void f_hide(String string, int n) {
        try {
            if (string.equals(UP_DIRECTORY)) {
                return;
            }
            FileConnection fileConnection = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + string));
            if (string.endsWith("/")) {
                Enumeration enumeration = fileConnection.list();
                FileConnection fileConnection2 = null;
                while (enumeration.hasMoreElements()) {
                    String string2;
                    String string3 = (String)enumeration.nextElement();
                    if (string3.charAt(string3.length() - 1) == '/') continue;
                    if (!string3.endsWith(".lck")) {
                        if (n == 2) continue;
                        fileConnection2 = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + string + string3));
                        string2 = string3.concat(".lck");
                        fileConnection2.rename(string2);
                        continue;
                    }
                    if (n == 1) continue;
                    fileConnection2 = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + string + string3));
                    string2 = string3.substring(0, string3.lastIndexOf(46));
                    fileConnection2.rename(string2);
                }
                if (fileConnection2 != null) {
                    fileConnection2.close();
                }
            } else if (!string.endsWith(".lck")) {
                if (n != 2) {
                    String string4 = string.concat(".lck");
                    fileConnection.rename(string4);
                }
            } else if (n != 1) {
                String string5 = string.substring(0, string.lastIndexOf(46));
                fileConnection.rename(string5);
            }
            fileConnection.close();
            this.showCurrDir();
        }
        catch (Exception exception) {
            Alert alert = new Alert("Error!", "Can not access file " + string + " in directory " + this.currDirName + "\nException: " + exception.getMessage(), null, AlertType.ERROR);
            alert.setTimeout(-2);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
        }
    }

    void setPass() {
        Form form = new Form("Set Password:");
        this.t_npass = new TextField("New Password:", null, 10, 65536);
        this.t_cpass = new TextField("Confirm Password:", null, 10, 65536);
        form.append((Item)this.t_npass);
        form.append((Item)this.t_cpass);
        form.addCommand(this.ch_passok);
        form.addCommand(this.ch_passca);
        form.setCommandListener((CommandListener)this);
        this.p_sorg = false;
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
    }

    void getPass() {
        Form form = new Form("Password:");
        this.t_pass = new TextField("Enter Password:", null, 10, 65536);
        form.append((Item)this.t_pass);
        form.addCommand(this.ch_passok);
        form.addCommand(this.ch_passca);
        form.setCommandListener((CommandListener)this);
        this.p_sorg = true;
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)form);
    }
}

